﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace NorthwindApp
{
    public partial class Form2 : Form
    {
        private string sciezka;        
        private NorthwindDataSet northwindDataSet = new NorthwindDataSet();        
        private int _pracownikaID;
        NorthwindDataSet.EmployeesRow er;

        public Form2(int pracownikaID = -1)
        {
            InitializeComponent();
            employeesTableAdapter1.Fill(northwindDataSet.Employees);

            if (pracownikaID != -1)
            {
                dodajRekordButton.Text = "Zatwierdź";
                _pracownikaID = pracownikaID;
                er = northwindDataSet.Employees.FindByEmployeeID(_pracownikaID);
                uzupelnijDane();
            }
            else
            {
                dodajRekordButton.Text = "Dodaj rekord";
            }
        }

        private void uzupelnijDane()
        {            
            imieTextBox.Text = er.FirstName;
            nazwiskoTextBox.Text = er.LastName;
            adresTextBox.Text = er.Address;
            miastoTextBox.Text = er.City;
            kodPocztowyTextBox.Text = er.PostalCode;
            panstwoTextBox.Text = er.Country;
            dataUrodzeniaDateTimePicker.Value = er.BirthDate.Date;
            dataZatrudnieniaDateTimePicker.Value = er.HireDate.Date;
            zdjecieTextBox.Text = er.PhotoPath;
            uwagiTextBox.Text = er.Notes;

            ImageConverter imageConverter = new ImageConverter();
            pictureBox1.Image = imageConverter.ConvertFrom(er.Photo) as Image;
            pictureBox1.SizeMode = PictureBoxSizeMode.StretchImage;
        }

        private void aktualizujDane()
        {
            er.FirstName = imieTextBox.Text;
            er.LastName = nazwiskoTextBox.Text;
            er.Address = adresTextBox.Text;
            er.City = miastoTextBox.Text;
            er.PostalCode = kodPocztowyTextBox.Text;
            er.Country = panstwoTextBox.Text;
            er.BirthDate = dataUrodzeniaDateTimePicker.Value.Date;
            er.HireDate = dataZatrudnieniaDateTimePicker.Value.Date;
            er.PhotoPath = zdjecieTextBox.Text;
            er.Notes = uwagiTextBox.Text;
            
            System.IO.MemoryStream ms = new System.IO.MemoryStream();
            pictureBox1.Image.Save(ms, System.Drawing.Imaging.ImageFormat.Gif);

            er.Photo = ms.ToArray();
        }
        
        private void zdjecieButton_Click(object sender, EventArgs e)
        {
            if (openFileDialog1.ShowDialog() == DialogResult.OK)
            {
                sciezka = openFileDialog1.FileName;
                zdjecieTextBox.Text = sciezka;                
                try
                {                    
                    pictureBox1.Image = new System.Drawing.Bitmap(sciezka);
                    pictureBox1.SizeMode = PictureBoxSizeMode.StretchImage;
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.Message);
                }
            }
        }

        private void dodajRekordButton_Click(object sender, EventArgs e)
        {
            // Kontrola wprowadzanych danych
            if (dataUrodzeniaDateTimePicker.Value.Date > DateTime.Today
                || dataZatrudnieniaDateTimePicker.Value.Date > DateTime.Today
                || dataZatrudnieniaDateTimePicker.Value < dataUrodzeniaDateTimePicker.Value)
            {
                MessageBox.Show("Podane daty są niepoprawne");
                return;
            }
                                
            // Wstawianie lub modyfikacja rekordu
            try
            {
                // Czy edycja?
                if (_pracownikaID != -1)
                {
                    aktualizujDane();
                    employeesTableAdapter1.Update(er);
                }
                else
                {
                    // Konwersja rysunku do tablicy typu byte
                    System.IO.MemoryStream ms = new System.IO.MemoryStream();
                    pictureBox1.Image.Save(ms, System.Drawing.Imaging.ImageFormat.Gif);

                    employeesTableAdapter1.Insert(nazwiskoTextBox.Text, imieTextBox.Text,
                        " ", " ", dataUrodzeniaDateTimePicker.Value.Date,
                        dataZatrudnieniaDateTimePicker.Value.Date, adresTextBox.Text,
                        miastoTextBox.Text, panstwoTextBox.Text, kodPocztowyTextBox.Text,
                        panstwoTextBox.Text, " ", " ", ms.ToArray(), uwagiTextBox.Text,
                        null, " ");
                }      
                this.Close();
            }
            catch (Exception ex)
            {
                MessageBox.Show("W trakcie próby wstawienia rekordu wystąpił błąd: \n" 
                    + ex.Message);
            }
        }

        private void wyczyscButton_Click(object sender, EventArgs e)
        {
            // Czyszczenie zawartości wszystkich pól tekstowych
            foreach(Control control in this.Controls)
            {
                if (control.GetType() == typeof(TextBox))
                    control.Text = "";
            }

            // Ustawienie domyślnych dat
            dataUrodzeniaDateTimePicker.Value = DateTime.Today.Date;
            dataZatrudnieniaDateTimePicker.Value = DateTime.Today.Date;

            // Usunięcie rysunku
            pictureBox1.Image = null;
        }
    }
}
